/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.jameica.plugin.AbstractPluginSource;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PluginSourceConfig
extends AbstractPluginSource {
    private List<File> dirs = null;

    @Override
    public PluginSource.Type getType() {
        return PluginSource.Type.CONFIG;
    }

    @Override
    public synchronized List<File> find() {
        File[] pluginDirs;
        if (this.dirs != null) {
            return this.dirs;
        }
        this.dirs = new ArrayList<File>();
        Logger.info((String)("searching for " + this.getType() + " plugins"));
        for (File pluginDir : pluginDirs = Application.getConfig().getPluginDirs()) {
            if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
                Logger.warn((String)("  skipping " + pluginDir.getAbsolutePath() + " - no directory or not readable"));
                continue;
            }
            Logger.info((String)("  adding dir " + pluginDir.getAbsolutePath()));
            this.dirs.add(pluginDir);
        }
        return this.dirs;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String getName() {
        return Application.getI18n().tr("Konfigurierte Plugin-Ordner");
    }

    @Override
    public File getDir() {
        return null;
    }
}

